# Copyright 2005, @Last Software, Inc.

# This software is provided as an example of using the Ruby interface
# to SketchUp.

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------

require 'sketchup.rb'

class LanguageHandler

    def initialize(fileName)

        @strings = Hash.new
        
        self.ParseLangFile(fileName)

    end

    def GetFullPath(fileName)

        langCode = Sketchup.get_locale
        
        fullFileName = fileName + langCode + ".strings"
        
        for i in 0..($:.length-1)
                
            testPath = $:[i] + "/" + fullFileName
        
            #UI.messagebox(testPath)
                
            if FileTest.exist?(testPath)
            
                puts "Found Path = " + testPath
                #UI.messagebox("Found Path = " + testPath)
                return testPath
            
            end 
        
        end
       
        puts "Language File does not exist at specified location (" + fileName + ")."
        return nil
            
    end

    def ParseLangFile(fileName)

        filePath = self.GetFullPath(fileName)
        
        if filePath==nil
        
            return false
            
        end
        
        langFile = File.open(filePath, "r")

		entryString = ""
		inComment = false
		
		langFile.each do |line|
				
			if line[0,2]!="//"
	        
				if line.include?("/*")
				
					inComment = true
					
				end
										
				if inComment==true and line.include?("*/")
				
					inComment=false
					
				else
				
					if inComment==false
					
						entryString += line
						
					end
	            	    
	            end
	            	    	            	    
   			end
   			
   			if entryString.include?(";")
   			
   				#parse the string into key and value
   				
   				#remove the white space
   				entryString.strip!

   				#pull out the key
   				keyvalue = entryString.split("\"=\"")
   				
   				key = keyvalue[0].gsub("\"", "")

   				#pull out the value
   				keyvalue[1].gsub!(";", "")
   				value = keyvalue[1].gsub("\"", "")   					

   				#add to @strings
   				@strings[key]=value
   				
   				entryString = ""
   			
   			end
	        
		end
		                                                
        return true
        
    end

    def GetString(key)
        
        retval = @strings[key]

        if retval!= nil
        
            retval.chomp!
            
        else
        
            retval = key
            
        end

        return retval
        
    end

end